/* 
    Copyright (c) 2004, Menaka Lashitha Bandara <lashi@optusnet.com.au>

    algorithm.h  - part of libalgorithm.
    
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef ALGORITHM_HEADER_DEFINED
#define ALGORITHM_HEADER_DEFIEND

#include <bool.h>
#include <monograph/graph.h>
#include <monograph/node.h>
#include <monograph/list.h>
#include <monograph/chromon.h>

extern bool stable (Node *n);
extern bool balanced (Node *n);
extern bool balanced2 (Node *n);
extern void gstabilise (MonoGraph *g);
extern void print_chromonlist (ChromonList *c);
extern unsigned int cochromatic (Node *n);
extern void flip_and_stabilise (Node *n, List *fliplist);
extern void stabilise (Node *n, List *fliplist);
extern ChromonList *minimise_chromons (MonoGraph *g);

#endif /* ALGORITHM_HEADER_DEFINED */
