/* 
    Copyleft (c) 2004, Menaka Lashitha Bandara <lashi@optusnet.com.au>

    exception.h  - part of libexception.
    
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef ASSERT_HEADER_DEFINED
#define ASSERT_HEADER_DEFINED

#include <stdio.h>
#include <stdlib.h>

#include "exception.h"

/* Thanks to Stewart, I got rid of do { } while (0); blocks,
 * and just used code blocks { } */
#ifdef __GNUC__
/* GNU C */
#define __ASSERT(type, ptype, options, condition)	 				\
	{										\
		if ( !(condition) ) {							\
			exception_raise (type, ptype, options, 				\
					"%s: %s, line %d: assertion (%s) failed!", 	\
					__PRETTY_FUNCTION__, __FILE__, __LINE__, 	\
					#condition);					\
											\
			exception_handle ();						\
		}									\
	}
#else
/* Not GNU C -- don't even know why I support this... */
#define __ASSERT(type, options, condition)	 					\
	{										\
		if ( !(condition) ) {							\
			exception_raise (type, options, 				\
					"Assertion (%s) failed!",			\
					#condition)					\
											\
			exception_handle ();						\
		}									\
	}
#endif /* !__GNUC__ */


#ifdef __DEBUG__
#define DEBUG_ASSERT(condition)		__ASSERT(BUG, "DebugAssertBug", CANCEL, condition)
#else
#define DEBUG_ASSERT(condition)		{ }
#endif /* __DEBUG__ */

#ifdef __NO_METHOD_ASSERT__
#define METHOD_ASSERT(condition)	{ }
#else
#define METHOD_ASSERT(condition)	__ASSERT(ERROR, "MethodAssertError", CANCEL,  condition)
#endif /* __NO_METHOD_ASSERT__ */
	
#endif /* ASSERT_HEADER_DEFINED */
