/* 
    Copyleft (c) 2004, Menaka Lashitha Bandara <lashi@optusnet.com.au>

    exception.h  - part of libexception.
    
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


/* Only one exception can occur at a given time.
 * If an exception is raised without clearing a
 * prior exception, then the exception handler is
 * called... */

/* This was ruthelessly inspired/(based) on Andrew
 * Clausen's GNU Parted exception handler... Please
 * see www.gnu.org/software/parted. */

#ifndef EXCEPTION_HEADER_DEFINED
#define EXCEPTION_HEADER_DEFINED

#ifdef __cplusplus 
extern "C" {
#endif

#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>

/* We can have 32 of these options... but can't
 * think of any more */
enum _EXOptions	{
	NONE	= 0,
	RETRY	= 1,	/* Retry action */
	CANCEL 	= 2,	/* Cancel action */
	IGNORE 	= 4,	/* Ignore error */
	OK	= 8,	/* Say 0K to query */
	YES	= 16,	/* Say Yes to query */
	NO	= 32,	/* Say No to query */
	FIX	= 64	/* Try and fix it */
};

enum _EXType {
	BUG,
	ERROR,
	FATAL,
	WARNING,
	INFORMATION,
	NO_FEATURE
};

/* Inbuilt Personal exception types */
#define	EXCEPTION_BUG		"Bug"
#define EXCEPTION_ERROR		"Error"
#define EXCEPTION_FATAL		"Fatal"
#define EXCEPTION_WARNING	"Warning"
#define EXCEPTION_INFORMATION	"Information"
#define EXCEPTION_NO_FEATURE	"NoFeature"

/* Won't compile under C++ if declarations of
 * enums are forwarded! */
typedef enum _EXOptions		EXOptions;
typedef enum _EXType		EXType;
typedef char * 			EXPersonalType;
typedef EXOptions		EXAction;

/* Exception Structure */
typedef struct _Exception	Exception;
typedef struct _ExceptionOps	ExceptionOps;

struct _Exception {
	char 		*message;
	EXType		type;
	EXPersonalType	catch_type;
	EXOptions	options;

	ExceptionOps	*ops;	/* Methods */
};

struct _ExceptionOps {
	EXOptions (*get_options) (Exception *exception);
	EXType (*get_type) (Exception *exception);
	EXPersonalType (*get_ptype) (Exception *exception);
	char *(*get_string) (Exception *exception);
};

#define	TRUNCATE_LIMIT	256

/* Inline this... We've got a bug in exception handler */
#define OUT_OF_MEMMORY() 	\
	{ 			\
		fprintf (stderr, "%s: exception handler ran out of memmory at line %d in %s", \
				__PRETTY_FUNCTION__, 	\
				__LINE__, __FILE__);			\
		exit (errno);	\
	}

#define MALLOC_ASSERT(node)	\
	{			\
		if ( !node ) { 	\
			exception_raise (FATAL, "MallocReturnedNULL",			\
					NONE, "%s: %d: %s failed to allocate memmory to node %s",  \
					__FILE__,	__LINE__, 			\
					__PRETTY_FUNCTION__, #node);			\
			exception_handle ();						\
				\
		}		\
	} 

/* Raise an exception, current exception returned */
extern Exception *exception_raise (EXType type, EXPersonalType catch_type, EXOptions opt, char *message, ...);
/* Clear any exceptions, this is dangerous, but useful if exception is caught */
extern void exception_clear (void);
/* Call to try and catch exception */
extern void exception_try (void);
/* Catch current exception -> note EXPersonalType is just String */
extern Exception *exception_catch (EXPersonalType catch_type);
/* Force the handler to handle exception */
extern void exception_handle (void);
/* Rethrow - this exception doesn't belong... */
extern void exception_rethrow (Exception *exception);
/* Compare exception types, good for writing external handlers */
extern int exception_type_compare (EXPersonalType type1, EXPersonalType type2);

/* Meta data crap */
/* Set exception handler, default (internal) handler is normally used */
extern void exception_set_handler (EXAction (*exception_handler) (Exception *exception));
extern void exception_reset_handler (void);
extern void exceptoin_set_message (char *default_message);
extern void exception_set_stream (FILE *stream);

#ifdef __cplusplus
}
#endif


#endif /* EXCEPTION_HEADER_DEFINED */
