/* 
    Copyright (c) 2004, Menaka Lashitha Bandara <lashi@optusnet.com.au>

    generator.h  - part of libgenerator.
    
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef GENERATOR_HEADER_DEFINED
#define GENERATOR_HEADER_DEFINED

#include <bool.h>
#include <stdlib.h> 
#include <stdio.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <monograph/graph.h>
#include <monograph/list.h>

typedef struct _Edge		Edge;

struct _Edge {
	unsigned int 	u;	/* Vertice i */ 
	unsigned int	v; 	/* Vertice j */

	unsigned int	r;	/* r val for this */ 
	unsigned int	interval; 
};

extern MonoGraph *generate_graph (unsigned int vertices);
extern MonoGraph *generate_graph_seed (unsigned int vertices, long int s);

#endif /* GENERATOR_HEADER_DEFINED */
