/* 
    Copyright (c) 2004, Menaka Lashitha Bandara <lashi@optusnet.com.au>

    chromon.h  - part of libmonograph.
    
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef CHROMON_HEADER_DEFINED
#define CHROMON_HEADER_DEFINED

#include <monograph/list.h>
#include <monograph/graph.h>
#include <bool.h>

typedef struct _ChromonV	ChromonV;
typedef struct _ChromonList	ChromonList;
typedef struct _ChromonOps	ChromonOps;

/* A single chromon, ie a maximal connected monochromatic
 * subgraph is simply a list of vertices corresponding to
 * that subgraph in our implementation */

/* We use a list based approach again */
struct _ChromonV {
	List		*list;
};

struct _ChromonList {
	List		*black;
	List		*white;
	
	/* Keeps track of which chromon each node is in */
	ChromonV	*vertice;

	/* We need to access the graph */
	MonoGraph	*graph;

	/* Methods */
	ChromonOps	*method;
};

struct _ChromonOps {
	/* Discover the chromons on graph g. Calling this again
	 * and again is slow. */
	void (*discover) (ChromonList *c, MonoGraph *g);

	/* Rediscover on a list of vertices */
	void (*rediscover) (ChromonList *c, List *list);
};

extern ChromonList *create_chromonlist (void);
extern void delete_chromonlist (ChromonList *c);

#endif /* CHROMON_HEADER_DEFINED */
