/* 
    Copyright (c) 2004, Menaka Lashitha Bandara <lashi@optusnet.com.au>

    graph.h  - part of libmonograph.
    
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef GRAPH_HEADER_DEFINED
#define GRAPH_HEADER_DEFINED

#include <exception/exception.h>
#include <monograph/node.h>

#include <stdlib.h>

typedef struct _MonoGraph		MonoGraph;
typedef struct _MonoGraphOps		MonoGraphOps;

struct _MonoGraph {
	unsigned int 		vertices;

	Node			**vlist;

	MonoGraphOps		*method;
};

struct _MonoGraphOps {
	Node **(*get_nodes) (MonoGraph *g);
	Node *(*get_node) (MonoGraph *g, unsigned int node);
	unsigned int (*get_size) (MonoGraph *g);

	void (*connect) (MonoGraph *g, unsigned int vertice, unsigned int to);
	void (*uconnect) (MonoGraph *g, unsigned int vertice, unsigned int to);
	void (*disconnect) (MonoGraph *g, unsigned int vertice, unsigned int to);
	void (*reset) (MonoGraph *g);
	
	MonoGraph *(*duplicate) (MonoGraph *g);
};

extern MonoGraph *create_graph (unsigned int vertices);
extern void delete_graph (MonoGraph *g);

#endif /* GRAPH_HEADER_DEFINED */
