/* 
    Copyright (c) 2004, Menaka Lashitha Bandara <lashi@optusnet.com.au>

    list.h  - part of libmonograph.
    
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef LIST_HEADER_DEFINED
#define LIST_HEADER_DEFINED

#include <exception/exception.h>
#include <exception/assert.h>

typedef struct _List		List;
typedef struct _ListOps		ListOps;
typedef struct _ListNode	ListNode;

struct _List {
	/* This is the root node */
	ListNode	*root;

	/* O(1) append */
	ListNode	*last;
	unsigned int	length;

	/* O(1) next() */
	ListNode	*cur;

	/* Methods available */
	ListOps		*method;
};

struct _ListNode {
	void		*data;

	ListNode 	*next;
	ListNode	*prev;
};

struct _ListOps {
	/* Returns data from head, removing the head */
	void *(*head) (List *l);
	/* Returns data from head, not removing the head */
	void *(*ndhead) (List *l);
	/* Steps forwards, and returns that element */
	void *(*next) (List *l);
	/* Steps backwards, and returns that element */
	void *(*prev) (List *l);
	/* Applies mapfunc () to each element in the list */
	void (*map) (List *l, void (*mapfunc) (void *data, void *param), void *param);

	/* Delete the element which contains *data, and return data */
	void *(*delete) (List *l, void *data);

	/* Constructs *data given a list, ie attach to front */
	ListNode *(*cons) (List *l, void *data);
	/* Appends to the list, returning a pointer to the node */
	ListNode *(*append) (List *l, void *data);
	/* Merge list m to list l (m is attached to the back of l) */
	List *(*merge) (List *l, List *m);

	/* Gives the length of the run */
	unsigned int (*length) (List *l);
	/* Returns the length from this node until NULL */
	unsigned int (*nlength) (ListNode *n);

	/* Reset the cur position */
	void (*reset) (List *l);
};

extern List *create_list (void);
extern void delete_list (List *l);

#endif /* LIST_HEADER_DEFINED */
