/* 
    Copyright (c) 2004, Menaka Lashitha Bandara <lashi@optusnet.com.au>

    node.h  - part of libmonograph.
    
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef NODE_HEADER_DEFINED
#define NODE_HEADER_DEFINED

#include <exception/exception.h>
#include <exception/assert.h>
#include <monograph/colour.h>

#define DEGREE		4

typedef struct _Node		Node;
typedef struct _NodeOps		NodeOps;

struct _Node {
	/* We have an id for each node. This makes this
	 * computationally efficient when we're travasing
	 * the graph */
	unsigned int	id;
	/* Assign a colouring */
	Colour		colour;
	
	unsigned int	neighbours;
	Node		*neighbour [DEGREE];

	/* Methods */
	NodeOps		*method;
};

struct _NodeOps {
	/* Node stuff */
	unsigned int (*get_id) (Node *n);
	void (*add_neighbour) (Node *n, Node *neighbour);
	Node *(*get_neighbour) (Node *n, unsigned int neighbour);
	void (*del_neighbour) (Node *n, Node *neighbour);
	unsigned int (*neighbour_count) (Node *n);
	
	/* Colouring */
	Colour (*get_colour) (Node *n);
	void (*set_colour) (Node *n, Colour c);
	void (*invert) (Node *n);
	void (*reset) (Node *n);
};

/* Always use construtors to create, even if you do
 * brutal optimisations with direct access to the privates
 * in struct _Node */

extern Node *create_node (unsigned int id);
extern void delete_node (Node *node);

#endif /* NODE_HEADER_DEFINED */
