/* 
    Copyright (c) 2004, Menaka Lashitha Bandara <lashi@optusnet.com.au>

    process.h - part of process.
    
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef PROCESS_HEADER_DEFINED
#define PROCESS_HEADER_DEFINED

/* Our helper */
#include "readgraph.h"

/* All the timing stuff */
#include <stdio.h>
#include <stdlib.h>
#include <sys/time.h>
#include <sys/resource.h>
#include <unistd.h>

/* All the algorithm related stuff */ 
#include <exception/exception.h>
#include <exception/assert.h>
#include <algorithm/ef.h>
#include <algorithm/hst.h>
#include <monograph/chromon.h>
#include <monograph/graph.h>
#include <monograph/list.h>
#include <generator/generator.h>

/* Option parsing */
#include <getopt.h>

/* Maths */
#include <math.h>

/* We use this data structure to store a pointer to 
 * function for the algorithm, and the text of teh algorithm. */
typedef struct _Algorithm	Algorithm;
struct _Algorithm {
	ChromonList *(*algorithm) (MonoGraph *);
	char	*name;
	List	*results;
};

/* Our primary data structure
 * This is what we use for reporting our data */

typedef struct _Data		Data;
struct _Data {
	unsigned long long int	time;
	unsigned int		max_chromon_size;
	float			average_chromon_size;
};

#endif /* PROCESS_HEADER_DEFINED */
