#include <monograph/graph.h>
#include <algorithm/ef.h>

int
main (void)
{
	MonoGraph	*g;

	/* Define Graph: */
	g = create_graph (5);

	g->method->uconnect (g, 0, 1);
	g->method->uconnect (g, 0, 2);
	g->method->uconnect (g, 0, 3);
	g->method->uconnect (g, 0, 4);
	g->method->uconnect (g, 1, 4);

	g->vlist [0]->method->set_colour (g->vlist [0], WHITE);
	g->vlist [1]->method->set_colour (g->vlist [1], WHITE);
	g->vlist [2]->method->set_colour (g->vlist [2], WHITE);
	g->vlist [3]->method->set_colour (g->vlist [3], WHITE);
	g->vlist [4]->method->set_colour (g->vlist [4], BLACK);

	/* Run EF on the graph */
	ef_algorithm (g);
	
	delete_graph (g);
	
	return 0;
}
