#include <monograph/graph.h>
#include <algorithm/ef.h>

#define set(g,v,c) \
	g->vlist [v]->colour = c;

#define connect(g,u,v) \
	g->method->uconnect (g, u, v)


int
main (void)
{
	MonoGraph	*g;

	g = create_graph (16);

	/* Structure */
	connect (g, 0, 1);
	connect (g, 0, 2);
	connect (g, 0, 3);
	connect (g, 0, 8);
	connect (g, 8, 9);
	connect (g, 8, 15);
	connect (g, 8, 10);
	connect (g, 15, 13);
	connect (g, 13, 11);
	connect (g, 13, 14);
	connect (g, 13, 12);
	connect (g, 3, 4);
	connect (g, 4, 5);
	connect (g, 4, 7);
	connect (g, 4, 6);
	
	/* Colour definitions */
	set (g, 15, WHITE);
	set (g, 12, WHITE);
	set (g, 0, WHITE);
	set (g, 3, WHITE);
	set (g, 7, WHITE);
	set (g, 1, WHITE);

	set (g, 11, BLACK);
	set (g, 13, BLACK);
	set (g, 14, BLACK);
	set (g, 10, BLACK);
	set (g, 9, BLACK);
	set (g, 8, BLACK);
	set (g, 2, BLACK);
	set (g, 4, BLACK);
	set (g, 5, BLACK);
	set (g, 6, BLACK);
	

	ef_algorithm (g);
	
	delete_graph (g);
}
