#include <monograph/graph.h>
#include <algorithm/ef.h>

#define set(g,v,c) \
	g->vlist [v]->colour = c;

#define connect(g,u,v) \
	g->method->uconnect (g, u, v)


int bl [] = { 1, 2, 3, 4, 5, 11, 12, 13, 14, 15, 16, -1};
int wh [] = { 6, 7, 8, 9, 10, -1};
	
int
main (void)
{
	MonoGraph	*g;
	unsigned int	i;

	g = create_graph (17);

	for ( i = 0;  bl [i] != -1; i++ )
		set (g, bl [i], BLACK);

	for ( i = 0; wh [i] != -1; i++ )
		set (g, wh [i], WHITE);

	connect (g, 0, 1);
	connect (g, 1, 2);
	connect (g, 2, 3);
	connect (g, 3, 4);
	connect (g, 3, 4);
	connect (g, 3, 6);
	connect (g, 3, 10);
	connect (g, 4, 5);
	connect (g, 5, 9);
	connect (g, 6, 7);
	connect (g, 7, 8);
	connect (g, 8, 9);
	connect (g, 9, 6);
	connect (g, 10, 11);
	connect (g, 11, 12);
	connect (g, 11, 16);
	connect (g, 13, 14);
	connect (g, 14, 15);
	connect (g, 15, 16);
	
	ef_algorithm (g);
	
	delete_graph (g);
}
