#include <stdio.h>
#include <stdlib.h>
#include <sys/time.h>
#include <sys/resource.h>
#include <unistd.h>

#include <monograph/graph.h>
#include <generator/generator.h>
#include <algorithm/ef.h>

int
main (int argc, char **argv)
{
	MonoGraph	*g;
	int		i;
	int		seed;
	struct rusage	myuse [2];
	
	if ( argc == 1 ) { 
		printf ("Args!!!");
		return 1;
	}

	i = atoi (argv [1]);

	if ( i < 4 ) {
		printf ("Need arg > 4");
		return 1;
	}

	if ( argc == 3 ) 
		g = generate_graph_seed (i, atoi (argv [2]));
	else 
		g = generate_graph (i);

	
	getrusage (RUSAGE_SELF, myuse);
	/* Ok, we do an EF */
	ef_algorithm (g);
	getrusage (RUSAGE_SELF, myuse + 1);

	/* This is the times used */
	printf ("Times:\n");
	printf ("\tSystem\t\t= %ds %dus\n", 
			myuse [1].ru_stime.tv_sec - myuse [0].ru_stime.tv_sec,
			myuse [1].ru_stime.tv_usec - myuse [0].ru_stime.tv_usec);
	printf ("\tUser\t\t= %ds %dus\n",
			myuse [1].ru_utime.tv_sec - myuse [0].ru_utime.tv_sec,
			myuse [1].ru_utime.tv_usec - myuse [0].ru_utime.tv_usec);
	printf ("\tTotal\t\t= %ds %dus\n",
			myuse [1].ru_stime.tv_sec - myuse [0].ru_stime.tv_sec +
			myuse [1].ru_utime.tv_sec - myuse [0].ru_utime.tv_sec,
			myuse [1].ru_stime.tv_usec - myuse [0].ru_stime.tv_usec +  
			myuse [1].ru_utime.tv_usec - myuse [0].ru_utime.tv_usec);




	return 0;
}
