#include <monograph/list.h>
#include <stdio.h>
#include <stdlib.h>

#define CRAZY_MAX		100

typedef struct _EComplex 	EComplex;
struct _EComplex {
	unsigned int 	n;
	char		string [500];
};

static EComplex *create_complex (unsigned int i);
static void delete_complex (EComplex *c);
static void print_crazylength (List *l, unsigned int n);

int
main (void)
{
	unsigned int 	i;
	List		*l;
	List		*m;
	EComplex		*c;

	l = create_list ();

	printf ("length = %d\n", l->length);

	/* Create our list */
	for ( i = 0; i < CRAZY_MAX; i++ )
		l->method->append (l, create_complex (i));

	print_crazylength (l, CRAZY_MAX / 2); printf ("\n");

	printf ("length =  %d\n", l->length);

	for ( i = CRAZY_MAX/4; i < CRAZY_MAX ; i++ )
		l->method->append (l, create_complex (i));

	printf ("length = %d\n", l->length);
	/* We print out the rest */
	print_crazylength (l, CRAZY_MAX / 2); printf ("\n");
	print_crazylength (l, CRAZY_MAX/4);


	/* Length must neccessarily be 0 to get to here */
	printf ("length = %d\n", l->length);

	/* Testing out the next stuff */
	while ( l->method->next (l) != (CRAZY_MAX / 2) )
		;

	
	m = l->method->split (l);

	printf ("length (l) = %d, length (m) = %d", 
			l->length, m->length);

	/* Keep this stuff there... */
	while ( l->length )
		delete_complex ( (EComplex *) l->method->head (l) );
	

	return 0;
		
}

static void
print_crazylength (List *l, unsigned int n)
{
	unsigned int	i;
	EComplex		*c;
	
	for ( i = 0; l->length > n; i++ ) {
		c = (EComplex *) l->method->next (l);
		printf ("%d\n", c->n);

		delete_complex (c);
	}

	return;
}

static EComplex 
*create_complex (unsigned int i)
{
	EComplex		*c;

	c = (EComplex *) malloc (sizeof (EComplex));

	c->n = i; 

	return c;
}

static void
delete_complex (EComplex *c)
{
	free (c);
}
